<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class ActivityLog extends Model
{
    use HasUuids;

    protected $fillable = [
        'student_id',
        'action',
        'description',
        'performed_by_type',
        'performed_by_id',
        'performed_by_name',
        'old_values',
        'new_values',
    ];

    protected $casts = [
        'old_values' => 'array',
        'new_values' => 'array',
    ];

    public function student()
    {
        return $this->belongsTo(Student::class);
    }
}