<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;

class ManualCertificateRecord extends Model
{
    use HasUuids;

    protected $fillable = [
        'certificate_number',
        'student_name',
        'course_name',
        'issuance_date',
        'center_id',
        'uploaded_by_type',
        'uploaded_by_id',
        'uploaded_by_name',
        'notes',
    ];

    protected $casts = [
        'issuance_date' => 'date',
    ];

    public function center()
    {
        return $this->belongsTo(Center::class);
    }
}