<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Concerns\HasUuids;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class Partner extends Authenticatable
{
    use HasUuids, Notifiable;

    protected $fillable = [
        'name',
        'email',
        'access_code',
        'center_id',
        'phone',
        'is_active',
        'is_manager',
    ];

    protected $hidden = [
        'remember_token',
    ];

    protected $visible_for_admin = [
        'access_code',
    ];

    protected $casts = [
        'email_verified_at' => 'datetime',
        'is_active' => 'boolean',
        'is_manager' => 'boolean',
    ];

    public function center()
    {
        return $this->belongsTo(Center::class);
    }
}
