<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('students', function (Blueprint $table) {
            $table->id();
            $table->string('name');
            $table->string('state_code')->unique();
            $table->string('course');
            $table->string('email');
            $table->string('phone');
            $table->string('center');
            $table->enum('payment_status', ['pending', 'paid', 'overdue'])->default('pending');
            $table->boolean('is_certified')->default(false);
            $table->date('enrollment_date');
            $table->date('certification_date')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('students');
    }
};
