<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->dropColumn(['course', 'payment_status', 'is_certified', 'certification_date']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('students', function (Blueprint $table) {
            $table->string('course');
            $table->enum('payment_status', ['pending', 'paid', 'overdue'])->default('pending');
            $table->boolean('is_certified')->default(false);
            $table->date('certification_date')->nullable();
        });
    }
};
