<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('certificate_credits', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->integer('credits_purchased');
            $table->integer('credits_used')->default(0);
            $table->integer('credits_remaining');
            $table->decimal('cost_per_credit', 8, 2);
            $table->decimal('total_cost', 10, 2);
            $table->string('purchased_by_type');
            $table->uuid('purchased_by_id');
            $table->string('purchased_by_name');
            $table->text('notes')->nullable();
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('certificate_credits');
    }
};
