<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('manual_certificate_records', function (Blueprint $table) {
            $table->uuid('id')->primary();
            $table->string('certificate_number')->unique();
            $table->string('student_name');
            $table->string('course_name');
            $table->date('issuance_date');
            $table->uuid('center_id')->nullable();
            $table->string('uploaded_by_type');
            $table->uuid('uploaded_by_id');
            $table->string('uploaded_by_name');
            $table->text('notes')->nullable();
            $table->timestamps();
            
            $table->foreign('center_id')->references('id')->on('centers')->onDelete('set null');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('manual_certificate_records');
    }
};
