<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Student;
use App\Models\Course;
use App\Models\StudentCourse;

class StudentSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $student1 = Student::create([
            'name' => 'John Doe',
            'state_code' => 'ST001',
            'email' => 'john@example.com',
            'phone' => '+1234567890',
            'center' => 'Lagos Center',
            'enrollment_date' => '2024-01-15',
        ]);

        $student2 = Student::create([
            'name' => 'Jane Smith',
            'state_code' => 'ST002',
            'email' => 'jane@example.com',
            'phone' => '+1234567891',
            'center' => 'Abuja Center',
            'enrollment_date' => '2024-02-01',
        ]);

        $student3 = Student::create([
            'name' => 'Mike Johnson',
            'state_code' => 'ST003',
            'email' => 'mike@example.com',
            'phone' => '+1234567892',
            'center' => 'Port Harcourt Center',
            'enrollment_date' => '2024-01-10',
        ]);

        // Get courses
        $webDev = Course::where('name', 'Web Development')->first();
        $dataScience = Course::where('name', 'Data Science')->first();
        $mobileDev = Course::where('name', 'Mobile App Development')->first();

        // Enroll students in courses
        StudentCourse::create([
            'student_id' => $student1->id,
            'course_id' => $webDev->id,
            'payment_status' => 'paid',
            'is_certified' => true,
            'enrollment_date' => '2024-01-15',
            'certification_date' => '2024-06-15',
        ]);

        StudentCourse::create([
            'student_id' => $student2->id,
            'course_id' => $dataScience->id,
            'payment_status' => 'pending',
            'enrollment_date' => '2024-02-01',
        ]);

        StudentCourse::create([
            'student_id' => $student3->id,
            'course_id' => $mobileDev->id,
            'payment_status' => 'paid',
            'is_certified' => true,
            'enrollment_date' => '2024-01-10',
            'certification_date' => '2024-07-10',
        ]);
    }
}
